DROP TABLE IF EXISTS `gx_configurations`;

CREATE TABLE IF NOT EXISTS `gx_configurations`
(
    `id`            int(11)      NOT NULL AUTO_INCREMENT,
    `key`           varchar(255) NOT NULL UNIQUE,
    `value`         mediumtext,
    `default`       mediumtext,
    `type`          varchar(255)                                  DEFAULT NULL,
    `sort_order`    int(5)                                        DEFAULT NULL,
    `last_modified` timestamp    NULL ON UPDATE CURRENT_TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    PRIMARY KEY (`id`)
)
    ENGINE = InnoDB
    DEFAULT CHARSET = `utf8`;

INSERT INTO `gx_configurations` (`key`, `value`, `default`, `type`, `sort_order`)
VALUES ('configuration/ACCOUNT_B2B_STATUS', 'false', 'false', 'switcher', 7),
('configuration/ACCOUNT_COMPANY', 'true', 'true', 'switcher', 3),
('configuration/ACCOUNT_COMPANY_REQUIRED', 'false', 'false', 'switcher', 3),
('configuration/ACCOUNT_COMPANY_VAT_CHECK', 'true', 'true', 'switcher', 4),
('configuration/ACCOUNT_COMPANY_VAT_GROUP', 'false', 'false', 'switcher', 4),
('configuration/ACCOUNT_COMPANY_VAT_LIVE_CHECK', 'true', 'true', 'switcher', 4),
('configuration/ACCOUNT_DEFAULT_B2B_STATUS', 'false', 'false', 'switcher', 8),
('configuration/ACCOUNT_DOB', 'false', 'false', 'switcher', 2),
('configuration/ACCOUNT_FAX', 'true', 'true', 'switcher', 1),
('configuration/ACCOUNT_GENDER', 'true', 'true', 'switcher', 1),
('configuration/ACCOUNT_OPTIONS', 'both', 'both', 'account-type', 6),
('configuration/ACCOUNT_TYPE_DEFAULT', 'account', 'account', 'account-template', 6),
('configuration/ACCOUNT_STATE', 'false', 'false', 'switcher', 5),
('configuration/ACCOUNT_ADDITIONAL_INFO', 'false', 'false', 'switcher', 5),
('configuration/ACCOUNT_SPLIT_STREET_INFORMATION', 'false', 'false', 'switcher', 5),
('configuration/ACCOUNT_SUBURB', 'false', 'false', 'switcher', 4),
('configuration/ACCOUNT_TELEPHONE', 'true', 'true', 'switcher', 1),
('configuration/ACCOUNT_VAT_BLOCK_ERROR', 'true', 'true', 'switcher', 4),
('configuration/ACCOUNT_NAMES_OPTIONAL', 'false', 'false', 'switcher', 9),
('configuration/ACCOUNT_CONFIRMATION_EMAIL', 'true', 'true', 'switcher', 2),
('configuration/ACTIVATE_GIFT_SYSTEM', 'false', 'false', 'switcher', 2),
('configuration/ACTIVATE_NAVIGATOR', 'false', 'false', 'switcher', 10),
('configuration/ACTIVATE_PAGE_TOKEN', 'true', 'true', 'switcher', 13),
('configuration/ACTIVATE_REVERSE_CROSS_SELLING', 'true', 'true', 'switcher', 12),
('configuration/ACTIVATE_SHIPPING_STATUS', 'true', 'true', 'switcher', 6),
('configuration/ADVANCED_SEARCH_DEFAULT_OPERATOR', 'and', 'and', 'search-operator', 30),
('configuration/APPEND_PROPERTIES_MODEL', 'true', 'true', 'switcher', 45),
('configuration/ATTRIBUTE_STOCK_CHECK', 'true', 'true', 'switcher', 2),
	('configuration/CACHE_CHECK', 'false', 'false', NULL, 4),
	('configuration/CACHE_LIFETIME', '3600', '3600', NULL, 3),
('configuration/CALCULATE_TAX_BASED_ON_VAT_ID', 'true', 'true', 'switcher', 8),
('configuration/CC_KEYCHAIN', 'tobechanged', 'tobechanged', NULL, 44),
('configuration/CC_NUMBER_MIN_LENGTH', '10', '10', 'number', 13),
('configuration/CC_OWNER_MIN_LENGTH', '3', '3', 'number', 12),
('configuration/CHECK_CLIENT_AGENT', 'true', 'true', 'switcher', 8),
	('configuration/COMPANY_NAME', '', '', NULL, 3),
('configuration/COMPRESS_EXPORT', 'false', 'false', NULL, 3),
('configuration/CONFIG_CALCULATE_IMAGE_SIZE', 'true', 'true', 'switcher', 1),
('configuration/CONTACT_US_EMAIL_ADDRESS', '', '', NULL, 20),
('configuration/CONTACT_US_FORWARDING_STRING', '', '', NULL, 25),
('configuration/CONTACT_US_NAME', 'Ihr Name', 'Ihr Name', NULL, 21),
('configuration/CONTACT_US_REPLY_ADDRESS', '', '', NULL, 22),
('configuration/CONTACT_US_REPLY_ADDRESS_NAME', 'Ihr Name', 'Ihr Name', NULL, 23),
	('configuration/CSV_SEPERATOR', '|', '|', NULL, 2),
	('configuration/CSV_TEXTSIGN', '', '', NULL, 1),
('configuration/DATE_TIMEZONE', 'Europe/Berlin', 'Europe/Berlin', NULL, 47),
	('configuration/DB_CACHE', 'false', 'false', NULL, 5),
('configuration/DB_CACHE_EXPIRE', '3600', '3600', NULL, 6),
('configuration/DEFAULT_CURRENCY', 'EUR', 'EUR', NULL, NULL),
('configuration/DEFAULT_CUSTOMERS_STATUS_ID', '2', '2', 'default-customer-group', 38),
('configuration/DEFAULT_CUSTOMERS_STATUS_ID_ADMIN', '0', '0', NULL, 35),
('configuration/DEFAULT_CUSTOMERS_STATUS_ID_GUEST', '1', '1', NULL, 36),
('configuration/DEFAULT_CUSTOMERS_VAT_STATUS_ID', '3', '3', 'default-customer-group', 23),
('configuration/DEFAULT_CUSTOMERS_VAT_STATUS_ID_LOCAL', '3', '3', 'default-customer-group', 24),
	('configuration/DEFAULT_LANGUAGE', 'de', 'de', NULL, NULL),
('configuration/DEFAULT_ORDERS_STATUS_ID', '1', '1', NULL, NULL),
('configuration/DEFAULT_PRODUCTS_VPE_ID', '', '', NULL, NULL),
('configuration/DEFAULT_SHIPPING_STATUS_ID', '1', '1', NULL, NULL),
('configuration/DELETE_GUEST_ACCOUNT', 'true', 'true', 'switcher', 7),
	('configuration/DIR_FS_CACHE', 'cache', 'cache', NULL, 2),
('configuration/DISPLAY_CART', 'true', 'true', 'switcher', 28),
('configuration/DISPLAY_PAGE_PARSE_TIME', 'false', 'false', 'switcher', 4),
('configuration/DOWNLOAD_BY_REDIRECT', 'false', 'false', 'switcher', 2),
('configuration/DOWNLOAD_ENABLED', 'true', 'true', 'switcher', 1),
('configuration/DOWNLOAD_MIN_ORDERS_STATUS', '3', '3', 'download-order-status', 5),
('configuration/DOWNLOAD_STOCK_CHECK', 'true', 'true', 'switcher', 3),
('configuration/DOWNLOAD_UNALLOWED_PAYMENT', 'banktransfer,cod,invoice,moneyorder',
 'banktransfer,cod,invoice,moneyorder', NULL, 5),
	('configuration/EMAIL_BILLING_ADDRESS', '', '', NULL, 32),
('configuration/EMAIL_BILLING_FORWARDING_STRING', '', '', NULL, 37),
('configuration/EMAIL_BILLING_NAME', 'Ihr Name', 'Ihr Name', NULL, 33),
('configuration/EMAIL_BILLING_REPLY_ADDRESS', '', '', NULL, 34),
('configuration/EMAIL_BILLING_REPLY_ADDRESS_NAME', 'Ihr Name', 'Ihr Name', NULL, 35),
('configuration/EMAIL_BILLING_SUBJECT', 'Verrechnung', 'Verrechnung', NULL, 36),
	('configuration/EMAIL_FROM', '', '', NULL, 15),
('configuration/EMAIL_LINEFEED', 'LF', 'LF', 'line-break', 10),
	('configuration/EMAIL_SIGNATURE', '', '', 'textarea', 16),
       ('configuration/EMAIL_HTML_SIGNATURE', '', '', 'textarea', 16),
	('configuration/EMAIL_SUPPORT_ADDRESS', '', '', NULL, 26),
('configuration/EMAIL_SUPPORT_FORWARDING_STRING', '', '', NULL, 31),
('configuration/EMAIL_SUPPORT_NAME', 'Ihr Name', 'Ihr Name', NULL, 27),
('configuration/EMAIL_SUPPORT_REPLY_ADDRESS', '', '', NULL, 28),
('configuration/EMAIL_SUPPORT_REPLY_ADDRESS_NAME', 'Ihr Name', 'Ihr Name', NULL, 29),
('configuration/EMAIL_SUPPORT_SUBJECT', 'Informationen zu Ihrem Kundenkonto',
 'Informationen zu Ihrem Kundenkonto', NULL, 30),
('configuration/EMAIL_TRANSPORT', 'mail', 'mail', 'email-transport-method', 1),
('configuration/EMAIL_USE_HTML', 'true', 'true', 'switcher', 11),
('configuration/ENTRY_CITY_MIN_LENGTH', '2', '2', 'number', 8),
('configuration/ENTRY_COMPANY_MIN_LENGTH', '2', '2', 'number', 6),
('configuration/ENTRY_DOB_MIN_LENGTH', '10', '10', 'number', 3),
('configuration/ENTRY_EMAIL_ADDRESS_CHECK', 'false', 'false', 'switcher', 12),
('configuration/ENTRY_EMAIL_ADDRESS_MIN_LENGTH', '6', '6', 'number', 4),
('configuration/ENTRY_FIRST_NAME_MIN_LENGTH', '2', '2', 'number', 1),
('configuration/ENTRY_LAST_NAME_MIN_LENGTH', '2', '2', 'number', 2),
('configuration/ENTRY_PASSWORD_MIN_LENGTH', '5', '5', 'number', 11),
('configuration/ENTRY_POSTCODE_MIN_LENGTH', '4', '4', 'number', 7),
('configuration/ENTRY_STATE_MIN_LENGTH', '2', '2', 'number', 9),
('configuration/ENTRY_STREET_ADDRESS_MIN_LENGTH', '1', '1', 'number', 5),
('configuration/ENTRY_HOUSENUMBER_MIN_LENGTH', '1', '1', 'number', 5),
('configuration/ENTRY_TELEPHONE_MIN_LENGTH', '0', '0', 'number', 10),
	('configuration/ERROR_REPORT_EMAIL', '', '', NULL, 8),
('configuration/EXPECTED_PRODUCTS_FIELD', 'date_expected', 'date_expected', 'products-order-by', 24),
('configuration/EXPECTED_PRODUCTS_SORT', 'asc', 'asc', 'ordering', 23),
	('configuration/GAMBIO_SHOP_KEY', '', '', NULL, 1),
('configuration/GENDER_MANDATORY', 'false', 'false', 'switcher', 9),
('configuration/GM_SET_OUT_OF_STOCK_ATTRIBUTES', 'false', 'false', 'switcher', NULL),
('configuration/GM_SET_OUT_OF_STOCK_ATTRIBUTES_SHOW', 'false', 'false', 'switcher', NULL),
('configuration/GM_SET_OUT_OF_STOCK_PRODUCTS', 'false', 'false', 'switcher', NULL),
	('configuration/GROUP_CHECK', 'false', 'false', 'switcher', 9),
('configuration/GZIP_COMPRESSION', 'true', 'true', 'switcher', 1),
	('configuration/GZIP_LEVEL', '9', '9', 'number', 2),
('configuration/HTML_COMPRESSION', 'false', 'false', 'switcher', 5),
	('configuration/HTTP_CACHING', 'true', 'true', NULL, 7),
('configuration/IMAGE_MANIPULATOR', 'image_manipulator_GD2.php', 'image_manipulator_GD2.php', NULL, 3),
	('configuration/IMAGE_QUALITY', '75', '75', 'number', 2),
('configuration/LOGGING_ENABLED', 'true', 'true', 'switcher', NULL),
('configuration/LOG_SQL_BACKEND', 'false', 'false', 'switcher', 6),
('configuration/LOG_SQL_FRONTEND', 'false', 'false', 'switcher', 5),
('configuration/MAX_ADDRESS_BOOK_ENTRIES', '5', '5', 'number', 1),
('configuration/MAX_DISPLAY_ALSO_PURCHASED', '4', '4', 'number', 16),
('configuration/MAX_DISPLAY_ALSO_PURCHASED_DAYS', '100', '100', 'number', 17),
('configuration/MAX_DISPLAY_BESTSELLERS', '5', '5', 'number', 15),
('configuration/MAX_DISPLAY_CATEGORIES_PER_ROW', '2', '2', 'number', 13),
('configuration/MAX_DISPLAY_MANUFACTURERS_IN_A_LIST', '1', '1', 'number', 7),
('configuration/MAX_DISPLAY_MANUFACTURER_NAME_LEN', '15', '15', 'number', 8),
('configuration/MAX_DISPLAY_NEW_PRODUCTS_DAYS', '30', '30', 'number', 22),
('configuration/MAX_DISPLAY_NEW_REVIEWS', '6', '6', 'number', 9),
('configuration/MAX_DISPLAY_ORDER_HISTORY', '5', '5', 'number', 19),
('configuration/MAX_DISPLAY_PAGE_LINKS', '4', '4', 'number', 3),
('configuration/MAX_DISPLAY_PRODUCTS_IN_ORDER_HISTORY_BOX', '6', '6', 'number', 18),
('configuration/MAX_DISPLAY_PRODUCTS_NEW', '10', '10', 'number', 14),
('configuration/MAX_DISPLAY_SEARCH_RESULTS', '8', '8', 'number', 2),
('configuration/MAX_DISPLAY_SPECIAL_PRODUCTS', '8', '8', 'number', 4),
('configuration/MAX_DISPLAY_UPCOMING_PRODUCTS', '5', '5', 'number', 6),
('configuration/MAX_MANUFACTURERS_LIST', '1', '1', 'number', 7),
('configuration/MAX_PRODUCTS_QTY', '1000000', '1000000', 'number', 21),
('configuration/MAX_RANDOM_SELECT_NEW', '30', '30', 'number', 11),
('configuration/MAX_RANDOM_SELECT_REVIEWS', '10', '10', 'number', 10),
('configuration/MAX_RANDOM_SELECT_SPECIALS', '10', '10', 'number', 12),
('configuration/MIN_DISPLAY_ALSO_PURCHASED', '1', '1', 'number', 16),
('configuration/MIN_DISPLAY_BESTSELLERS', '1', '1', 'number', 15),
('configuration/MODULE_BRICKFOX_EXCLUDE_CATEGORIES', '', '', NULL, 5),
('configuration/MODULE_BRICKFOX_EXCLUDE_PRODUCTS', '', '', NULL, 6),
('configuration/MODULE_BRICKFOX_PASSWORD', '', '', NULL, 4),
('configuration/MODULE_BRICKFOX_PORT', '443', '443', NULL, 2),
('configuration/MODULE_BRICKFOX_STATUS', 'False', 'False', 'switcher', 7),
	('configuration/MODULE_BRICKFOX_URL', '', '', NULL, 1),
('configuration/MODULE_BRICKFOX_USERNAME', '', '', NULL, 3),
('configuration/MODULE_DELISPRINT_FILE', 'delisprint.txt', 'delisprint.txt', NULL, 1),
('configuration/MODULE_DELISPRINT_STATUS', 'True', 'True', 'switcher', 1),
('configuration/MODULE_EXPORT_INSTALLED', 'magnalister.php', 'magnalister.php', NULL, NULL),
('configuration/MODULE_GLS_FILE', 'gls.txt', 'gls.txt', NULL, 1),
('configuration/MODULE_GLS_STATUS', 'True', 'True', 'switcher', 1),
('configuration/MODULE_HERMES_FILE', 'hermes.txt', 'hermes.txt', NULL, 1),
('configuration/MODULE_HERMES_STATUS', 'True', 'True', 'switcher', 1),
('configuration/MODULE_ORDER_TOTAL_COD_FEE_RULES',
 'free|AT:3.00,DE:3.58,00:9.99|flat|AT:3.00,DE:3.58,00:9.99|item|AT:3.00,DE:3.58,00:9.99|table|AT:3.00,DE:3.58,00:9.99|zones|CA:4.50,US:3.00,00:9.99|upse|AT:3.00,DE:3.58,00:9.99|chronopost|FR:4.00,00:9.99|dhl|AT:3.00,DE:3.58,00:9.99|ups|AT:3.00,DE:3.58,00:9.99|chp|CH:4.00,00:9.99|dpd|DE:4.00,00:9.99|ap|AT:3.63,00:9.99|zonese|DE:4.00,00:9.99|selfpickup|DE:4.00,00:9.99|gambioultra|DE:4.00,00:9.99|fedexeu|DE:4.00,00:9.99|dp|DE:4.00,00:9.99',
 'free|AT:3.00,DE:3.58,00:9.99|flat|AT:3.00,DE:3.58,00:9.99|item|AT:3.00,DE:3.58,00:9.99|table|AT:3.00,DE:3.58,00:9.99|zones|CA:4.50,US:3.00,00:9.99|upse|AT:3.00,DE:3.58,00:9.99|chronopost|FR:4.00,00:9.99|dhl|AT:3.00,DE:3.58,00:9.99|ups|AT:3.00,DE:3.58,00:9.99|chp|CH:4.00,00:9.99|dpd|DE:4.00,00:9.99|ap|AT:3.63,00:9.99|zonese|DE:4.00,00:9.99|selfpickup|DE:4.00,00:9.99|gambioultra|DE:4.00,00:9.99|fedexeu|DE:4.00,00:9.99|dp|DE:4.00,00:9.99',
 'cod-fee', NULL),
('configuration/MODULE_ORDER_TOTAL_COD_FEE_SORT_ORDER', '35', '35', NULL, NULL),
('configuration/MODULE_ORDER_TOTAL_COD_FEE_STATUS', 'true', 'true', 'switcher', NULL),
('configuration/MODULE_ORDER_TOTAL_COD_FEE_TAX_CLASS', '0', '0', 'tax-class', NULL),
('configuration/MODULE_ORDER_TOTAL_COD_FEE_TRANSFER_CHARGE',
 'ap|00:0|chp|00:0|chronopost|00:0|dhl|00:0|dp|00:0|dpd|00:0|fedexeu|00:0|flat|00:0|free|00:0|freeamount|00:0|gambioultra|00:0|item|00:0|selfpickup|00:0|table|00:0|ups|00:0|upse|00:0|zones|00:0|zonese|00:0',
 'ap|00:0|chp|00:0|chronopost|00:0|dhl|00:0|dp|00:0|dpd|00:0|fedexeu|00:0|flat|00:0|free|00:0|freeamount|00:0|gambioultra|00:0|item|00:0|selfpickup|00:0|table|00:0|ups|00:0|upse|00:0|zones|00:0|zonese|00:0',
 'cod-fee', NULL),
('configuration/MODULE_ORDER_TOTAL_COUPON_CALC_TAX', 'Standard', 'Standard', 'tax-calculation-mode', 7),
('configuration/MODULE_ORDER_TOTAL_COUPON_INC_SHIPPING', 'false', 'false', 'switcher', 5),
('configuration/MODULE_ORDER_TOTAL_COUPON_INC_TAX', 'true', 'true', 'switcher', 6),
('configuration/MODULE_ORDER_TOTAL_COUPON_SHOW_INFO', 'false', 'false', 'switcher', 9),
('configuration/MODULE_ORDER_TOTAL_COUPON_SORT_ORDER', '70', '70', NULL, 2),
('configuration/MODULE_ORDER_TOTAL_COUPON_STATUS', 'true', 'true', 'switcher', 1),
('configuration/MODULE_ORDER_TOTAL_COUPON_TAX_CLASS', '0', '0', 'tax-class', NULL),
('configuration/MODULE_ORDER_TOTAL_DISCOUNT_SORT_ORDER', '20', '20', NULL, 2),
('configuration/MODULE_ORDER_TOTAL_DISCOUNT_STATUS', 'true', 'true', 'switcher', 1),
('configuration/MODULE_ORDER_TOTAL_FREEAMOUNT_FREE', 'AT:3.00,DE:3.58,00:9.99', 'AT:3.00,DE:3.58,00:9.99',
 NULL, NULL),
('configuration/MODULE_ORDER_TOTAL_GV_CALC_TAX', 'None', 'None', 'tax-calculation-mode', 7),
('configuration/MODULE_ORDER_TOTAL_GV_CREDIT_TAX', 'false', 'false', 'switcher', 8),
('configuration/MODULE_ORDER_TOTAL_GV_INC_SHIPPING', 'False', 'False', 'switcher', 5),
('configuration/MODULE_ORDER_TOTAL_GV_INC_TAX', 'true', 'true', 'switcher', 6),
('configuration/MODULE_ORDER_TOTAL_GV_QUEUE', 'true', 'true', 'switcher', 3),
('configuration/MODULE_ORDER_TOTAL_GV_SHOW_INFO', 'false', 'false', 'switcher', 9),
('configuration/MODULE_ORDER_TOTAL_GV_SORT_ORDER', '80', '80', NULL, 2),
('configuration/MODULE_ORDER_TOTAL_GV_STATUS', 'true', 'true', 'switcher', 1),
('configuration/MODULE_ORDER_TOTAL_GV_TAX_CLASS', '0', '0', 'tax-class', NULL),
('configuration/MODULE_ORDER_TOTAL_INSTALLED',
 'ot_subtotal.php;ot_discount.php;ot_coupon.php;ot_shipping.php;ot_cod_fee.php;ot_gv.php;ot_subtotal_no_tax.php;ot_tax.php;ot_total_netto.php;ot_total.php',
 'ot_subtotal.php;ot_discount.php;ot_coupon.php;ot_shipping.php;ot_cod_fee.php;ot_gv.php;ot_subtotal_no_tax.php;ot_tax.php;ot_total_netto.php;ot_total.php',
 NULL, NULL),
('configuration/MODULE_ORDER_TOTAL_SHIPPING_DESTINATION', 'national', 'national', 'shipping-destination', 5),
('configuration/MODULE_ORDER_TOTAL_SHIPPING_FREE_SHIPPING', 'false', 'false', 'switcher', 3),
('configuration/MODULE_ORDER_TOTAL_SHIPPING_FREE_SHIPPING_OVER', '50', '50', NULL, 4),
('configuration/MODULE_ORDER_TOTAL_SHIPPING_SORT_ORDER', '30', '30', NULL, 2),
('configuration/MODULE_ORDER_TOTAL_SHIPPING_STATUS', 'true', 'true', 'switcher', 1),
('configuration/MODULE_ORDER_TOTAL_SHIPPING_TAX_CLASS', '0', '0', 'tax-class', 7),
('configuration/MODULE_ORDER_TOTAL_SHIPPING_SHOW_TITLE', 'true', 'true', 'switcher', 8),
('configuration/MODULE_ORDER_TOTAL_SUBTOTAL_NO_TAX_SORT_ORDER', '96', '96', NULL, 2),
('configuration/MODULE_ORDER_TOTAL_SUBTOTAL_NO_TAX_STATUS', 'true', 'true', 'switcher', 1),
('configuration/MODULE_ORDER_TOTAL_SUBTOTAL_SORT_ORDER', '10', '10', NULL, 2),
('configuration/MODULE_ORDER_TOTAL_SUBTOTAL_STATUS', 'true', 'true', 'switcher', 1),
('configuration/MODULE_ORDER_TOTAL_TAX_SORT_ORDER', '97', '97', NULL, 2),
('configuration/MODULE_ORDER_TOTAL_TAX_STATUS', 'true', 'true', 'switcher', 1),
('configuration/MODULE_ORDER_TOTAL_TOTAL_NETTO_SORT_ORDER', '98', '98', NULL, 2),
('configuration/MODULE_ORDER_TOTAL_TOTAL_NETTO_STATUS', 'false', 'false', 'switcher', 1),
('configuration/MODULE_ORDER_TOTAL_TOTAL_SORT_ORDER', '99', '99', NULL, 2),
('configuration/MODULE_ORDER_TOTAL_TOTAL_STATUS', 'true', 'true', 'switcher', 1),
('configuration/MODULE_PAYMENT_SEPA_COMPANY', '', '', NULL, NULL),
('configuration/MODULE_PAYMENT_SEPA_CREDITOR_ID', '', '', NULL, NULL),
('configuration/MODULE_PAYMENT_SEPA_POSTCODE_CITY', '', '', NULL, NULL),
('configuration/MODULE_PAYMENT_SEPA_SEND_MANDATE', 'true', 'true', NULL, NULL),
('configuration/MODULE_PAYMENT_SEPA_STREET_ADDRESS', '', '', NULL, NULL),
('configuration/MODULE_SHIPPING_INSTALLED', '', '', NULL, NULL),
('configuration/MODULE_PAYMENT_INSTALLED', '', '', NULL, NULL),
	('configuration/MO_PICS', '1000', '1000', 'number', 3),
('configuration/NEW_SIGNUP_DISCOUNT_COUPON', '', '', NULL, 5),
('configuration/NEW_SIGNUP_GIFT_VOUCHER_AMOUNT', '', '', NULL, 4),
('configuration/PAYPAL_API_KEY',
 '120,116,99,111,109,109,101,114,99,101,95,83,104,111,112,112,105,110,103,67,97,114,116,95',
 '120,116,99,111,109,109,101,114,99,101,95,83,104,111,112,112,105,110,103,67,97,114,116,95', NULL, 5),
	('configuration/PAYPAL_API_PWD', '', '', NULL, 5),
('configuration/PAYPAL_API_SANDBOX_PWD', '', '', NULL, 5),
('configuration/PAYPAL_API_SANDBOX_SIGNATURE', '', '', NULL, 6),
('configuration/PAYPAL_API_SANDBOX_USER', '', '', NULL, 4),
	('configuration/PAYPAL_API_SIGNATURE', '', '', NULL, 6),
	('configuration/PAYPAL_API_USER', '', '', NULL, 4),
('configuration/PAYPAL_COUNTRY_MODE', 'de', 'de', NULL, 16),
('configuration/PAYPAL_EXPRESS_ADDRESS_CHANGE', 'true', 'true', NULL, 17),
('configuration/PAYPAL_EXPRESS_ADDRESS_OVERRIDE', 'true', 'true', NULL, 18),
('configuration/PAYPAL_EXPRESS_PAYMENTACTION', 'Sale', 'Sale', NULL, 16),
	('configuration/PAYPAL_MODE', 'live', 'live', NULL, 1),
('configuration/PAYPAL_ORDER_STATUS_PENDING_ID', '1', '1', NULL, 11),
('configuration/PAYPAL_ORDER_STATUS_REJECTED_ID', '1', '1', NULL, 12),
('configuration/PAYPAL_ORDER_STATUS_SUCCESS_ID', '2', '2', NULL, 10),
('configuration/PAYPAL_ORDER_STATUS_TMP_ID', '1', '1', NULL, 9),
	('configuration/PAYPAL_SHOP_LOGO', '', '', NULL, 13),
('configuration/PREFER_GZHANDLER', 'false', 'false', 'switcher', 3),
('configuration/PRICE_IS_BRUTTO', 'true', 'true', 'switcher', 42),
	('configuration/PRICE_PRECISION', '4', '4', 'number', 43),
('configuration/PRODUCT_IMAGE_INFO_HEIGHT', '350', '350', 'number', 10),
('configuration/PRODUCT_IMAGE_INFO_WIDTH', '369', '369', 'number', 9),
('configuration/PRODUCT_IMAGE_POPUP_HEIGHT', '600', '600', 'number', 12),
('configuration/PRODUCT_IMAGE_POPUP_WIDTH', '600', '600', 'number', 11),
('configuration/PRODUCT_IMAGE_THUMBNAIL_HEIGHT', '130', '130', 'number', 8),
('configuration/PRODUCT_IMAGE_THUMBNAIL_WIDTH', '150', '150', 'number', 7),
	('configuration/PRODUCT_LIST_FILTER', '1', '1', '1-0-switcher', 52),
('configuration/PRODUCT_REVIEWS_VIEW', '5', '5', 'number', 20),
('configuration/QUICKLINK_ACTIVATED', 'true', 'true', 'switcher', 11),
('configuration/REVIEW_TEXT_MIN_LENGTH', '50', '50', 'number', 14),
('configuration/SEARCH_IN_ATTR', 'false', 'false', 'switcher', 50),
('configuration/SEARCH_IN_DESC', 'true', 'true', 'switcher', 51),
('configuration/SECURITY_CODE_LENGTH', '10', '10', 'switcher', 3),
('configuration/SENDMAIL_PATH', '/usr/sbin/sendmail', '/usr/sbin/sendmail', NULL, 2),
('configuration/SEND_EMAILS', 'true', 'true', 'switcher', 13),
('configuration/SEND_EMAIL_BY_BILLING_ADRESS', 'SHOP_OWNER', 'SHOP_OWNER', 'sender-mail', 40),
('configuration/SESSION_CHECK_IP_ADDRESS', 'False', 'False', 'switcher', 5),
('configuration/SESSION_CHECK_USER_AGENT', 'False', 'False', 'switcher', 4),
('configuration/SESSION_FORCE_COOKIE_USE', 'False', 'False', 'switcher', 2),
('configuration/SESSION_RECREATE', 'True', 'True', 'switcher', 7),
	('configuration/SESSION_TIMEOUT', '24', '24', 'number', 8),
	('configuration/SESSION_KEEP_ALIVE', '1', '1', 'switcher', 9),
	('configuration/SHIPPING_BOX_PADDING', '0', '0', NULL, 5),
	('configuration/SHIPPING_BOX_WEIGHT', '0', '0', NULL, 4),
('configuration/SHIPPING_INFOS', '3889891', '3889891', NULL, 5),
('configuration/SHIPPING_MAX_WEIGHT', '50', '50', NULL, 3),
('configuration/SHIPPING_ORIGIN_COUNTRY', '81', '81', 'country', 1),
('configuration/SHIPPING_ORIGIN_ZIP', '12345', '12345', NULL, 2),
('configuration/SHOW_CART_SHIPPING_COSTS', 'true', 'true', 'switcher', 8),
('configuration/SHOW_CART_SHIPPING_WEIGHT', 'true', 'true', 'switcher', 9),
('configuration/SHOW_COUNTS', 'false', 'false', 'switcher', 32),
('configuration/SHOW_SHIPPING', 'true', 'true', 'switcher', 6),
('configuration/SHOW_UNTRANSLATED_MENUITEMS', 'false', 'false', 'switcher', 13),
('configuration/SMTP_AUTH', 'false', 'false', 'switcher', 8),
('configuration/SMTP_Backup_Server', 'localhost', 'localhost', NULL, 4),
('configuration/SMTP_ENCRYPTION', 'none', 'none', 'smtp-encryption', 9),
('configuration/SMTP_MAIN_SERVER', 'localhost', 'localhost', NULL, 3),
('configuration/SMTP_PASSWORD', 'Please Enter', 'Please Enter', NULL, 7),
	('configuration/SMTP_PORT', '25', '25', NULL, 5),
('configuration/SMTP_USERNAME', '', '', NULL, 6),
('configuration/SQL_LOG_MAX_FILESIZE', '1', '1', 'number', 7),
('configuration/STOCK_ALLOW_CHECKOUT', 'true', 'true', 'switcher', 5),
('configuration/STOCK_CHECK', 'true', 'true', 'switcher', 1),
('configuration/STOCK_LIMITED', 'true', 'true', 'switcher', 4),
('configuration/STOCK_MARK_PRODUCT_OUT_OF_STOCK', '***', '***', NULL, 6),
	('configuration/STOCK_REORDER_LEVEL', '5', '5', NULL, 7),
('configuration/CHECK_STOCK_BEFORE_SHOPPING_CART', 'false', 'false', 'switcher', 8),
('configuration/STORE_COUNTRY', '81', '81', 'country', 10),
('configuration/STORE_DB_TRANSACTIONS', 'false', 'false', 'switcher', 8),
('configuration/STORE_NAME', 'Shopname', 'Shopname', NULL, 1),
('configuration/STORE_NAME_ADDRESS', '', '', 'textarea', 17),
('configuration/STORE_OWNER', 'Shopbetreiber', 'Shopbetreiber', NULL, 2),
('configuration/STORE_OWNER_EMAIL_ADDRESS', '', '', NULL, 14),
('configuration/STORE_PAGE_PARSE_TIME', 'false', 'false', 'switcher', 1),
('configuration/STORE_PAGE_PARSE_TIME_LOG', '/tmp/', '/tmp/', NULL, 2),
('configuration/STORE_ZONE', '88', '88', 'country-zone', 11),
	('configuration/TRADER_FAX', '', '', NULL, 13),
	('configuration/TRADER_FIRSTNAME', '', '', NULL, 4),
	('configuration/TRADER_LOCATION', '', '', NULL, 9),
	('configuration/TRADER_NAME', '', '', NULL, 5),
	('configuration/TRADER_STREET', '', '', NULL, 6),
	('configuration/TRADER_STREET_NUMBER', '', '', NULL, 7),
	('configuration/TRADER_TEL', '', '', NULL, 12),
	('configuration/TRADER_ZIPCODE', '', '', NULL, 8),
('configuration/UNFOLD_FAVS_BOX', 'false', 'false', 'switcher', 48),
	('configuration/USE_CACHE', 'false', 'false', NULL, 1),
('configuration/USE_DEFAULT_LANGUAGE_CURRENCY', 'false', 'false', 'switcher', 25),
	('configuration/USE_WYSIWYG', 'true', 'true', 'switcher', 1),
('configuration/_PAYMENT_SKRILL_CANCELED_STATUS_ID', '0', '0', NULL, 8),
('configuration/_PAYMENT_SKRILL_EMAILID', '', '', NULL, 1),
('configuration/_PAYMENT_SKRILL_EXPERTMODE', '0', '0', NULL, 9),
('configuration/_PAYMENT_SKRILL_MERCHANTID', '', '', NULL, 3),
('configuration/_PAYMENT_SKRILL_MODULES', '', '', NULL, 4),
('configuration/_PAYMENT_SKRILL_PENDING_STATUS_ID', '0', '0', NULL, 7),
('configuration/_PAYMENT_SKRILL_PROCESSED_STATUS_ID', '0', '0', NULL, 6),
('configuration/_PAYMENT_SKRILL_PWD', '', '', NULL, 2),
('configuration/_PAYMENT_SKRILL_TMP_STATUS_ID', '0', '0', NULL, 5),
('configuration/EMAIL_MAX_LIMIT', '1000', '1000', NULL, 99),
('configuration/MODULE_PAYMENT_AMAZONADVPAY_ALIAS', 'AMAZ', 'AMAZ', NULL, NULL),
('configuration/MODULE_PAYMENT_BILLSAFE_3_INSTALLMENT_ALIAS', 'BSRA', 'BSRA', NULL, NULL),
('configuration/MODULE_PAYMENT_BILLSAFE_3_INVOICE_ALIAS', 'BSRE', 'BSRE', NULL, NULL),
('configuration/MODULE_PAYMENT_CASH_ALIAS', 'BAR', 'BAR', NULL, NULL),
('configuration/MODULE_PAYMENT_EUSTANDARDTRANSFER_ALIAS', 'EUS', 'EUS', NULL, NULL),
('configuration/MODULE_PAYMENT_BANKTRANSFER_ALIAS', 'LS', 'LS', NULL, NULL),
('configuration/MODULE_PAYMENT_SEPA_ALIAS', 'SEPA', 'SEPA', NULL, NULL),
('configuration/MODULE_PAYMENT_COD_ALIAS', 'NN', 'NN', NULL, NULL),
('configuration/MODULE_PAYMENT_INVOICE_ALIAS', 'RECH', 'RECH', NULL, NULL),
('configuration/MODULE_PAYMENT_MONEYORDER_ALIAS', 'VK', 'VK', NULL, NULL),
('configuration/MODULE_PAYMENT_PAYPAL3_ALIAS', 'PP', 'PP', NULL, NULL),
('configuration/MODULE_PAYMENT_KLARNA_INVOICE_ALIAS', 'KLRE', 'KLRE', NULL, NULL),
('configuration/MODULE_PAYMENT_KLARNA_PARTPAY_ALIAS', 'KLRA', 'KLRA', NULL, NULL),
('configuration/MODULE_PAYMENT_IPAYMENT_CC_ALIAS', 'IPCC', 'IPCC', NULL, NULL),
('configuration/MODULE_PAYMENT_IPAYMENT_ELV_ALIAS', 'IPEL', 'IPEL', NULL, NULL),
('configuration/MODULE_PAYMENT_MASTERPAYMENT_ANZAHLUNGSKAUF_ALIAS', 'MAAN', 'MAAN', NULL, NULL),
('configuration/MODULE_PAYMENT_MASTERPAYMENT_CONFIG_ALIAS', 'MACO', 'MACO', NULL, NULL),
('configuration/MODULE_PAYMENT_MASTERPAYMENT_CREDIT_CARD_ALIAS', 'MACC', 'MACC', NULL, NULL),
('configuration/MODULE_PAYMENT_MASTERPAYMENT_DEBIT_CARD_ALIAS', 'MADC', 'MADC', NULL, NULL),
('configuration/MODULE_PAYMENT_MASTERPAYMENT_ELV_ALIAS', 'MAEL', 'MAEL', NULL, NULL),
('configuration/MODULE_PAYMENT_MASTERPAYMENT_FINANZIERUNG_ALIAS', 'MAFI', 'MAFI', NULL, NULL),
('configuration/MODULE_PAYMENT_MASTERPAYMENT_PHONE_ALIAS', 'MAPH', 'MAPH', NULL, NULL),
('configuration/MODULE_PAYMENT_MASTERPAYMENT_RATENZAHLUNG_ALIAS', 'MARA', 'MARA', NULL, NULL),
('configuration/MODULE_PAYMENT_MASTERPAYMENT_RECHNUNGSKAUF_ALIAS', 'MARE', 'MARE', NULL, NULL),
('configuration/MODULE_PAYMENT_MASTERPAYMENT_SOFORTBANKING_ALIAS', 'MASO', 'MASO', NULL, NULL),
('configuration/MODULE_PAYMENT_SHOPGATE_ALIAS', 'SHG', 'SHG', NULL, NULL),
('configuration/MODULE_PAYMENT_SKRILL_CC_ALIAS', 'SKCC', 'SKCC', NULL, NULL),
('configuration/MODULE_PAYMENT_SKRILL_CGB_ALIAS', 'SKCB', 'SKCB', NULL, NULL),
('configuration/MODULE_PAYMENT_SKRILL_CSI_ALIAS', 'SKCS', 'SKCS', NULL, NULL),
('configuration/MODULE_PAYMENT_SKRILL_ELV_ALIAS', 'SKEL', 'SKEL', NULL, NULL),
('configuration/MODULE_PAYMENT_SKRILL_GIROPAY_ALIAS', 'SKGP', 'SKGP', NULL, NULL),
('configuration/MODULE_PAYMENT_SKRILL_IDEAL_ALIAS', 'SKID', 'SKID', NULL, NULL),
('configuration/MODULE_PAYMENT_SKRILL_MAE_ALIAS', 'SKMA', 'SKMA', NULL, NULL),
('configuration/MODULE_PAYMENT_SKRILL_NETPAY_ALIAS', 'SKNE', 'SKNE', NULL, NULL),
('configuration/MODULE_PAYMENT_SKRILL_PSP_ALIAS', 'SKPP', 'SKPP', NULL, NULL),
('configuration/MODULE_PAYMENT_SKRILL_PWY_ALIAS', 'SKPR', 'SKPR', NULL, NULL),
('configuration/MODULE_PAYMENT_SKRILL_SFT_ALIAS', 'SKSU', 'SKSU', NULL, NULL),
('configuration/MODULE_PAYMENT_SKRILL_WLT_ALIAS', 'SKEW', 'SKEW', NULL, NULL),
('configuration/MODULE_PAYMENT_SKRILL_PAYINV_ALIAS', 'SKRE', 'SKRE', NULL, NULL),
('configuration/MODULE_PAYMENT_SKRILL_PAYINS_ALIAS', 'SKRA', 'SKRA', NULL, NULL),
('configuration/MODULE_PAYMENT_PAYGATE_SSL_ALIAS', 'PAYG', 'PAYG', NULL, NULL),
('configuration/MODULE_PAYMENT_POSTFINANCEAG_BASIC_ALIAS', 'POFI', 'POFI', NULL, NULL),
('configuration/MODULE_PAYMENT_POSTFINANCEAG_DINERS_ALIAS', 'PODI', 'PODI', NULL, NULL),
('configuration/MODULE_PAYMENT_POSTFINANCEAG_MASTERCARD_ALIAS', 'POMA', 'POMA', NULL, NULL),
('configuration/MODULE_PAYMENT_POSTFINANCEAG_AMEX_ALIAS', 'POAM', 'POAM', NULL, NULL),
('configuration/MODULE_PAYMENT_POSTFINANCEAG_VISA_ALIAS', 'POVI', 'POVI', NULL, NULL),
('configuration/MODULE_PAYMENT_SOFORT_SOFORTUEBERWEISUNG_ALIAS', 'SÜ', 'SÜ', NULL, NULL),
('configuration/MODULE_SHIPPING_GAMBIOULTRA_ALIAS', 'ARTV', 'ARTV', NULL, NULL),
('configuration/MODULE_SHIPPING_CHRONOPOST_ALIAS', 'CHRO', 'CHRO', NULL, NULL),
('configuration/MODULE_SHIPPING_DP_ALIAS', 'Deutsche Post', 'DHL', NULL, NULL),
('configuration/MODULE_SHIPPING_DHL_ALIAS', 'DHLA', 'DHLA', NULL, NULL),
('configuration/MODULE_SHIPPING_DPD_ALIAS', 'DPD', 'DPD', NULL, NULL),
('configuration/MODULE_SHIPPING_FEDEXEU_ALIAS', 'FED', 'FED', NULL, NULL),
('configuration/MODULE_SHIPPING_HERMESPROPS_ALIAS', 'HERM', 'HERM', NULL, NULL),
('configuration/MODULE_SHIPPING_INTERKURIER_ALIAS', 'INT', 'INT', NULL, NULL),
('configuration/MODULE_SHIPPING_AP_ALIAS', 'ATP', 'ATP', NULL, NULL),
('configuration/MODULE_SHIPPING_FLAT_ALIAS', 'PAU', 'PAU', NULL, NULL),
('configuration/MODULE_SHIPPING_CHP_ALIAS', 'CHP', 'CHP', NULL, NULL),
('configuration/MODULE_SHIPPING_SELFPICKUP_ALIAS', 'ABH', 'ABH', NULL, NULL),
('configuration/MODULE_SHIPPING_UPSE_ALIAS', 'UPSE', 'UPSE', NULL, NULL),
('configuration/MODULE_SHIPPING_UPS_ALIAS', 'UPS', 'UPS', NULL, NULL),
('configuration/MODULE_SHIPPING_ZONES_ALIAS', 'UNV', 'UNV', NULL, NULL),
('configuration/MODULE_SHIPPING_B2CZONES_ALIAS', 'VER', 'VER', NULL, NULL),
('configuration/MODULE_SHIPPING_TABLE_ALIAS', 'VKPG', 'VKPG', NULL, NULL),
('configuration/MODULE_SHIPPING_ITEM_ALIAS', 'VKST', 'VKST', NULL, NULL),
('configuration/MODULE_SHIPPING_FREEAMOUNT_ALIAS', 'FREI', 'FREI', NULL, NULL),
('configuration/MODULE_SHIPPING_ZONESE_ALIAS', 'VERS', 'VERS', NULL, NULL),
('configuration/MOVE_ONLY_IF_NO_GUEST', 'true', 'true', 'switcher', 4),
('configuration/CURRENT_THEME', 'Malibu', 'Malibu', NULL, 42),
('configuration/STORE_OWNER_VAT_ID', '', '', NULL, 3),
('configuration/MAX_DISPLAY_CROSSSELLING', '4', '4', 'number', 16),
('configuration/USE_BUSTFILES', 'false', 'false', 'switcher', 5),
('configuration/SESSION_CHECK_SSL_SESSION_ID', 'false', 'false', 'switcher', 5);

INSERT INTO `gx_configurations` (`key`, `value`, `default`, `type`, `sort_order`)
VALUES ('gm_configuration/ATTACH_CONDITIONS_OF_USE_IN_ORDER_CONFIRMATION', '1', '1', '1-0-switcher', NULL),
('gm_configuration/ATTACH_PRIVACY_NOTICE_IN_ORDER_CONFIRMATION', '1', '1', '1-0-switcher', NULL),
('gm_configuration/ATTACH_WITHDRAWAL_FORM_IN_ORDER_CONFIRMATION', '1', '1', '1-0-switcher', NULL),
('gm_configuration/ATTACH_WITHDRAWAL_INFO_IN_ORDER_CONFIRMATION', '1', '1', '1-0-switcher', NULL),
('gm_configuration/DOWNLOAD_DELAY_FOR_ABANDONMENT_OF_WITHDRAWL_RIGHT', '0', '1', 'seconds', NULL),
('gm_configuration/DOWNLOAD_DELAY_WITHOUT_ABANDONMENT_OF_WITHDRAWL_RIGHT', '0', '1', 'seconds', NULL),
('gm_configuration/CAT_MENU_CLASSIC', 'false', 'false', NULL, NULL),
('gm_configuration/CAT_MENU_LEFT', 'false', 'false', 'switcher', NULL),
('gm_configuration/GM_SHOW_CAT', 'none', 'false', 'dropdown', NULL),
('gm_configuration/CAT_MENU_TOP', 'true', 'true', 'switcher', NULL),
('gm_configuration/CATEGORY_ACCORDION_EFFECT', 'false', 'false', 'switcher', NULL),
('gm_configuration/CATEGORY_DISPLAY_SHOW_ALL_LINK', 'true', 'true', 'switcher', NULL),
('gm_configuration/CATEGORY_UNFOLD_LEVEL', '0', '0', 'number', NULL),
('gm_configuration/CATEGORY_TOP_SHOW_LEVEL', '2', '2', 'number', NULL),
('gm_configuration/CUSTOMIZER_POSITION', '1', '1', NULL, NULL),
('gm_configuration/DISPLAY_TAX', '1', '1', '1-0-switcher', NULL),
('gm_configuration/EKOMI_API_ID', '', '', NULL, NULL),
('gm_configuration/EKOMI_API_PASSWORD', '', '', NULL, NULL),
('gm_configuration/EKOMI_STATUS', '0', '0', NULL, NULL),
('gm_configuration/EKOMI_WIDGET_CODE', '', '', NULL, NULL),
('gm_configuration/ENABLE_RATING', 'true', 'true', 'switcher', NULL),
('gm_configuration/FEATURE_DISPLAY_MODE', '0', '0', NULL, NULL),
('gm_configuration/FEATURE_EMPTY_BOX_MODE', '0', '0', NULL, NULL),
('gm_configuration/FEATURE_MODE', '0', '0', NULL, NULL),
('gm_configuration/GLOBAL_FILTER', '0', '0', NULL, NULL),
('gm_configuration/GM_ANALYTICS_CODE', '', '', NULL, NULL),
('gm_configuration/GM_ANALYTICS_CODE_USE', '0', '0', '1-0-switcher', NULL),
('gm_configuration/GM_AUTO_SHIPPING_STATUS', 'true', 'true', NULL, NULL),
('gm_configuration/GM_CALLBACK_SERVICE_VVCODE', 'true', 'true', 'switcher', NULL),
('gm_configuration/GM_CAPTCHA_TYPE', 'standard', 'standard', 'captcha-type', NULL),
('gm_configuration/GM_CART_ON_TOP', 'true', 'true', NULL, NULL),
('gm_configuration/GM_CAT_HOVER', '#b3ccdd', '#b3ccdd', NULL, NULL),
('gm_configuration/GM_CHECK_CONDITIONS', '0', '0', '1-0-switcher', NULL),
('gm_configuration/GM_CHECK_PRIVACY_ACCOUNT_ADDRESS_BOOK', '1', '1', '1-0-switcher', NULL),
('gm_configuration/GM_CHECK_PRIVACY_ACCOUNT_CONTACT', '1', '1', '1-0-switcher', NULL),
('gm_configuration/GM_CHECK_PRIVACY_ACCOUNT_NEWSLETTER', '1', '1', '1-0-switcher', NULL),
('gm_configuration/GM_CHECK_PRIVACY_CALLBACK', '1', '1', '1-0-switcher', NULL),
('gm_configuration/GM_CHECK_PRIVACY_CHECKOUT_PAYMENT', '1', '1', '1-0-switcher', NULL),
('gm_configuration/GM_CHECK_PRIVACY_CHECKOUT_SHIPPING', '1', '1', '1-0-switcher', NULL),
('gm_configuration/GM_CHECK_PRIVACY_CONTACT', '1', '1', '1-0-switcher', NULL),
('gm_configuration/GM_CHECK_PRIVACY_FOUND_CHEAPER', '1', '1', '1-0-switcher', NULL),
('gm_configuration/GM_CHECK_PRIVACY_ORDER', '0', '0', NULL, NULL),
('gm_configuration/GM_CHECK_PRIVACY_REVIEWS', '1', '1', '1-0-switcher', NULL),
('gm_configuration/GM_CHECK_PRIVACY_TELL_A_FRIEND', '1', '1', '1-0-switcher', NULL),
('gm_configuration/GM_CHECK_WITHDRAWAL', '0', '0', '1-0-switcher', NULL),
('gm_configuration/GM_COOKIE_STATUS', 'false', 'false', 'switcher', NULL),
('gm_configuration/GM_COOKIE_POSITION', 'top', 'top', NULL, NULL),
('gm_configuration/GM_COOKIE_COLOR', '#ffffff', '#ffffff', NULL, NULL),
('gm_configuration/GM_COOKIE_TRANSPARENCY', '1', '1', NULL, NULL),
('gm_configuration/GM_COOKIE_CLOSE_ICON', 'false', 'false', NULL, NULL),
('gm_configuration/GM_COOKIE_BUTTON_TEXT_COLOR', '#ffffff', '#ffffff', NULL, NULL),
('gm_configuration/GM_COOKIE_BUTTON_COLOR', '#002337', '#002337', NULL, NULL),
('gm_configuration/GM_CONFIRM_IP', '1', '1', '1-0-switcher', NULL),
('gm_configuration/GM_CONTACT_VVCODE', 'true', 'true', 'switcher', NULL),
('gm_configuration/GM_COUNTER_IP_BARRIER', '86400', '86400', NULL, NULL),
('gm_configuration/GM_FORGOT_PASSWORD_VVCODE', 'true', 'true', 'switcher', NULL),
('gm_configuration/GM_GAMBIO_CORNER', '1', '1', NULL, NULL),
('gm_configuration/GM_GPRINT_ALLOWED_FILE_EXTENSIONS', 'jpg,png,gif,jpeg', 'jpg,png,gif,jpeg', NULL, NULL),
('gm_configuration/GM_GPRINT_AUTO_WIDTH', '1', '1', NULL, NULL),
('gm_configuration/GM_GPRINT_CHARACTER_LENGTH', '0', '0', NULL, NULL),
('gm_configuration/GM_GPRINT_EXCLUDE_SPACES', '1', '1', NULL, NULL),
('gm_configuration/GM_GPRINT_SHOW_TABS', '1', '1', NULL, NULL),
('gm_configuration/GM_GPRINT_UPLOADS_PER_IP', '0', '0', NULL, NULL),
('gm_configuration/GM_GPRINT_UPLOADS_PER_IP_INTERVAL', '60', '60', NULL, NULL),
('gm_configuration/GM_HIDE_ATTR_OUT_OF_STOCK', '0', '0', NULL, NULL),
('gm_configuration/GM_LIGHTBOX_CART', 'false', 'false', NULL, NULL),
('gm_configuration/GM_LIGHTBOX_CHECKOUT', 'false', 'false', NULL, NULL),
('gm_configuration/GM_LIGHTBOX_CREATE_ACCOUNT', 'false', 'false', NULL, NULL),
('gm_configuration/GM_LOG_IP', '0', '0', '1-0-switcher', NULL),
('gm_configuration/GM_LOGIN_TIMELINE', '20', '20', 'number', NULL),
('gm_configuration/GM_LOGIN_TIMEOUT', '20', '20', 'number', NULL),
('gm_configuration/GM_LOGIN_TRYOUT', '2', '2', 'number', NULL),
('gm_configuration/GM_LOGO_CAT', 'item_ltr.gif', 'item_ltr.gif', NULL, NULL),
('gm_configuration/GM_LOGO_CAT_SIZE_H', '13', '13', NULL, NULL),
('gm_configuration/GM_LOGO_CAT_SIZE_W', '5', '5', NULL, NULL),
('gm_configuration/GM_LOGO_CAT_USE', '1', '1', NULL, NULL),
('gm_configuration/GM_LOGO_FAVICON', 'favicon.ico', 'favicon.ico', NULL, NULL),
('gm_configuration/GM_LOGO_FAVICON_IPAD', 'favicon.png', 'favicon.png', NULL, NULL),
('gm_configuration/GM_LOGO_FAVICON_IPAD_USE', '0', '0', NULL, NULL),
('gm_configuration/GM_LOGO_FAVICON_USE', '1', '1', NULL, NULL),
	('gm_configuration/GM_LOGO_FLASH', '', '', NULL, NULL),
('gm_configuration/GM_LOGO_FLASH_SIZE_H', '600', '600', NULL, NULL),
('gm_configuration/GM_LOGO_FLASH_SIZE_W', '160', '160', NULL, NULL),
('gm_configuration/GM_LOGO_FLASH_USE', '0', '0', NULL, NULL),
('gm_configuration/GM_LOGO_MAIL', 'email_logo.gif', 'email_logo.gif', NULL, NULL),
('gm_configuration/GM_LOGO_MAIL_USE', '1', '1', NULL, NULL),
('gm_configuration/GM_LOGO_OVERLAY', 'overlay.gif', 'overlay.gif', NULL, NULL),
('gm_configuration/GM_LOGO_OVERLAY_USE', '0', '0', NULL, NULL),
('gm_configuration/GM_LOGO_PDF', 'pdf_logo.gif', 'pdf_logo.gif', NULL, NULL),
('gm_configuration/GM_LOGO_PDF_USE', '1', '1', NULL, NULL),
('gm_configuration/GM_LOGO_SHOP', 'gx4_shop_logo.svg', 'gx4_shop_logo.svg', NULL, NULL),
('gm_configuration/GM_LOGO_SHOP_SIZE_H', '96', '96', NULL, NULL),
('gm_configuration/GM_LOGO_SHOP_SIZE_W', '142', '142', NULL, NULL),
('gm_configuration/GM_LOGO_SHOP_USE', '1', '1', NULL, NULL),
('gm_configuration/GM_NEW_PRODUCTS_STARTPAGE', '3', '3', 'number', NULL),
('gm_configuration/GM_NEWSLETTER_VVCODE', 'true', 'true', 'switcher', NULL),
('gm_configuration/GM_NEXT_INVOICE_ID', '1', '1', NULL, NULL),
('gm_configuration/GM_NEXT_PACKINGS_ID', '1', '1', NULL, NULL),
('gm_configuration/GM_ORDER_STATUS_CANCEL_ID', '99', '99', 'number', NULL),
('gm_configuration/GM_ORDER_STATUS_INVOICE_CREATED_ID', '149', '149', NULL, NULL),
('gm_configuration/GM_PACKINGS_ID', CONCAT('L_{DELIVERY_ID}_', YEAR(NOW())), CONCAT('L_{DELIVERY_ID}_', YEAR(NOW())), NULL, NULL),
('gm_configuration/GM_INVOICE_ID', CONCAT('R_{INVOICE_ID}_', YEAR(NOW())), CONCAT('R_{INVOICE_ID}_', YEAR(NOW())), NULL, NULL),
('gm_configuration/GM_PASSWORD_ENCRYPTION_TYPE', 'password_hash', 'password_hash', 'password-encryption-type', NULL),
('gm_configuration/GM_PASSWORD_REENCRYPT', 'true', 'true', 'switcher', NULL),
('gm_configuration/GM_PDF_ALLOW_COPYING', '1', '1', NULL, NULL),
('gm_configuration/GM_PDF_ALLOW_MODIFYING', '1', '1', NULL, NULL),
('gm_configuration/GM_PDF_ALLOW_NOTIFYING', '1', '1', NULL, NULL),
('gm_configuration/GM_PDF_BOTTOM_MARGIN', '10', '10', NULL, NULL),
('gm_configuration/GM_PDF_CANCEL_FONT_COLOR', '#000000', '#000000', NULL, NULL),
('gm_configuration/GM_PDF_CANCEL_FONT_FACE', 'freesans', 'freesans', NULL, NULL),
('gm_configuration/GM_PDF_CANCEL_FONT_SIZE', '11', '11', NULL, NULL),
('gm_configuration/GM_PDF_CANCEL_FONT_STYLE', 'b', 'b', NULL, NULL),
('gm_configuration/GM_PDF_CELL_HEIGHT', '5', '5', NULL, NULL),
('gm_configuration/GM_PDF_COMPANY_LEFT_FONT_COLOR', '#000000', '#000000', NULL, NULL),
('gm_configuration/GM_PDF_COMPANY_LEFT_FONT_FACE', 'freesans', 'freesans', NULL, NULL),
('gm_configuration/GM_PDF_COMPANY_LEFT_FONT_SIZE', '9', '9', NULL, NULL),
('gm_configuration/GM_PDF_COMPANY_LEFT_FONT_STYLE', 'u', 'u', NULL, NULL),
('gm_configuration/GM_PDF_COMPANY_RIGHT_FONT_COLOR', '#000000', '#000000', NULL, NULL),
('gm_configuration/GM_PDF_COMPANY_RIGHT_FONT_FACE', 'freesans', 'freesans', NULL, NULL),
('gm_configuration/GM_PDF_COMPANY_RIGHT_FONT_SIZE', '11', '11', NULL, NULL),
('gm_configuration/GM_PDF_COMPANY_RIGHT_FONT_STYLE', '', '', NULL, NULL),
('gm_configuration/GM_PDF_CONDITIONS_FONT_COLOR', '#000000', '#000000', NULL, NULL),
('gm_configuration/GM_PDF_CONDITIONS_FONT_FACE', 'freesans', 'freesans', NULL, NULL),
('gm_configuration/GM_PDF_CONDITIONS_FONT_SIZE', '11', '11', NULL, NULL),
('gm_configuration/GM_PDF_CONDITIONS_FONT_STYLE', '', '', NULL, NULL),
('gm_configuration/GM_PDF_CUSTOMER_ADR_POS', '50', '50', NULL, NULL),
('gm_configuration/GM_PDF_CUSTOMER_FONT_COLOR', '#000000', '#000000', NULL, NULL),
('gm_configuration/GM_PDF_CUSTOMER_FONT_FACE', 'freesans', 'freesans', NULL, NULL),
('gm_configuration/GM_PDF_CUSTOMER_FONT_SIZE', '11', '11', NULL, NULL),
('gm_configuration/GM_PDF_CUSTOMER_FONT_STYLE', '', '', NULL, NULL),
('gm_configuration/GM_PDF_DEFAULT_FONT_COLOR', '#000000', '#000000', NULL, NULL),
('gm_configuration/GM_PDF_DEFAULT_FONT_FACE', 'freesans', 'freesans', NULL, NULL),
('gm_configuration/GM_PDF_DEFAULT_FONT_SIZE', '11', '11', NULL, NULL),
('gm_configuration/GM_PDF_DEFAULT_FONT_STYLE', 'b', 'b', NULL, NULL),
('gm_configuration/GM_PDF_DISPLAY_LAYOUT', 'continuous', 'continuous', NULL, NULL),
('gm_configuration/GM_PDF_DISPLAY_OUTPUT', 'I', 'I', NULL, NULL),
('gm_configuration/GM_PDF_DISPLAY_ZOOM', 'real', 'real', NULL, NULL),
('gm_configuration/GM_PDF_DRAW_COLOR', '#0065AC', '#0065AC', NULL, NULL),
('gm_configuration/GM_PDF_FIX_HEADER', '1', '1', NULL, NULL),
('gm_configuration/GM_PDF_FOOTER_FONT_COLOR', '#000000', '#000000', NULL, NULL),
('gm_configuration/GM_PDF_FOOTER_FONT_FACE', 'freesans', 'freesans', NULL, NULL),
('gm_configuration/GM_PDF_FOOTER_FONT_SIZE', '10', '10', NULL, NULL),
('gm_configuration/GM_PDF_FOOTER_FONT_STYLE', '', '', NULL, NULL),
('gm_configuration/GM_PDF_HEADING_CONDITIONS_FONT_COLOR', '#000000', '#000000', NULL, NULL),
('gm_configuration/GM_PDF_HEADING_CONDITIONS_FONT_FACE', 'freesans', 'freesans', NULL, NULL),
('gm_configuration/GM_PDF_HEADING_CONDITIONS_FONT_SIZE', '11', '11', NULL, NULL),
('gm_configuration/GM_PDF_HEADING_CONDITIONS_FONT_STYLE', 'b', 'b', NULL, NULL),
('gm_configuration/GM_PDF_HEADING_FONT_COLOR', '#000000', '#000000', NULL, NULL),
('gm_configuration/GM_PDF_HEADING_FONT_FACE', 'freesans', 'freesans', NULL, NULL),
('gm_configuration/GM_PDF_HEADING_FONT_SIZE', '11', '11', NULL, NULL),
('gm_configuration/GM_PDF_HEADING_FONT_STYLE', 'b', 'b', NULL, NULL),
('gm_configuration/GM_PDF_HEADING_MARGIN_BOTTOM', '15', '15', NULL, NULL),
('gm_configuration/GM_PDF_HEADING_MARGIN_TOP', '15', '15', NULL, NULL),
('gm_configuration/GM_PDF_HEADING_ORDER_FONT_COLOR', '#000000', '#000000', NULL, NULL),
('gm_configuration/GM_PDF_HEADING_ORDER_FONT_FACE', 'freesans', 'freesans', NULL, NULL),
('gm_configuration/GM_PDF_HEADING_ORDER_FONT_SIZE', '10', '10', NULL, NULL),
('gm_configuration/GM_PDF_HEADING_ORDER_FONT_STYLE', 'b', 'b', NULL, NULL),
('gm_configuration/GM_PDF_HEADING_ORDER_INFO_FONT_COLOR', '#000000', '#000000', NULL, NULL),
('gm_configuration/GM_PDF_HEADING_ORDER_INFO_FONT_FACE', 'freesans', 'freesans', NULL, NULL),
('gm_configuration/GM_PDF_HEADING_ORDER_INFO_FONT_SIZE', '11', '11', NULL, NULL),
('gm_configuration/GM_PDF_HEADING_ORDER_INFO_FONT_STYLE', 'b', 'b', NULL, NULL),
('gm_configuration/GM_PDF_INVOICE_USE_CURRENT_DATE', '1', '1', NULL, NULL),
('gm_configuration/GM_PDF_INVOICE_DATE', '', '', NULL, NULL),
('gm_configuration/GM_PDF_LEFT_MARGIN', '10', '10', NULL, NULL),
('gm_configuration/GM_PDF_LOGO_SRC', 'pdf_logo.gif', 'pdf_logo.gif', NULL, NULL),
('gm_configuration/GM_PDF_ORDER_FONT_COLOR', '#000000', '#000000', NULL, NULL),
('gm_configuration/GM_PDF_ORDER_FONT_FACE', 'freesans', 'freesans', NULL, NULL),
('gm_configuration/GM_PDF_ORDER_FONT_SIZE', '10', '10', NULL, NULL),
('gm_configuration/GM_PDF_ORDER_FONT_STYLE', '', '', NULL, NULL),
('gm_configuration/GM_PDF_ORDER_INFO_FONT_COLOR', '#000000', '#000000', NULL, NULL),
('gm_configuration/GM_PDF_ORDER_INFO_FONT_FACE', 'freesans', 'freesans', NULL, NULL),
('gm_configuration/GM_PDF_ORDER_INFO_FONT_SIZE', '11', '11', NULL, NULL),
('gm_configuration/GM_PDF_ORDER_INFO_FONT_STYLE', '', '', NULL, NULL),
('gm_configuration/GM_PDF_ORDER_INFO_MARGIN_TOP', '30', '30', NULL, NULL),
('gm_configuration/GM_PDF_ORDER_STATUS_INVOICE', '149', '149', NULL, NULL),
('gm_configuration/GM_PDF_ORDER_STATUS_INVOICE_MAIL', '149', '149', NULL, NULL),
('gm_configuration/GM_PDF_ORDER_TOTAL_FONT_COLOR', '#000000', '#000000', NULL, NULL),
('gm_configuration/GM_PDF_ORDER_TOTAL_FONT_FACE', 'freesans', 'freesans', NULL, NULL),
('gm_configuration/GM_PDF_ORDER_TOTAL_FONT_SIZE', '11', '11', NULL, NULL),
('gm_configuration/GM_PDF_ORDER_TOTAL_FONT_STYLE', '', '', NULL, NULL),
('gm_configuration/GM_PDF_PACKING_SLIP_USE_CURRENT_DATE', '1', '1', NULL, NULL),
('gm_configuration/GM_PDF_PACKING_SLIP_DATE', '', '', NULL, NULL),
('gm_configuration/GM_PDF_RIGHT_MARGIN', '10', '10', NULL, NULL),
('gm_configuration/GM_PDF_TOP_MARGIN', '10', '10', NULL, NULL),
('gm_configuration/GM_PDF_MAX_AMOUNT_INVOICES_BULK_PDF', '100', '100', NULL, NULL),
('gm_configuration/GM_PDF_MAX_AMOUNT_PACKING_SLIPS_BULK_PDF', '100', '100', NULL, NULL),
('gm_configuration/GM_PDF_USE_CONDITIONS', '1', '1', NULL, NULL),
('gm_configuration/GM_PDF_USE_CUSTOMER_CODE', '1', '1', NULL, NULL),
('gm_configuration/GM_PDF_USE_CUSTOMER_COMMENT', '1', '1', NULL, NULL),
('gm_configuration/GM_PDF_USE_DATE', '1', '1', NULL, NULL),
('gm_configuration/GM_PDF_USE_FOOTER', '1', '1', NULL, NULL),
('gm_configuration/GM_PDF_USE_HEADER', '1', '1', NULL, NULL),
('gm_configuration/GM_PDF_USE_INFO', '1', '1', NULL, NULL),
('gm_configuration/GM_PDF_USE_INFO_TEXT', '1', '1', NULL, NULL),
('gm_configuration/GM_PDF_USE_INVOICE_CODE', '1', '1', NULL, NULL),
('gm_configuration/GM_PDF_USE_ORDER_CODE', '1', '1', NULL, NULL),
('gm_configuration/GM_PDF_USE_ORDER_DATE', '1', '1', NULL, NULL),
('gm_configuration/GM_PDF_USE_PACKING_CODE', '1', '1', NULL, NULL),
('gm_configuration/GM_PDF_USE_PRODUCTS_MODEL', '1', '1', NULL, NULL),
('gm_configuration/GM_PDF_USE_WITHDRAWAL', '1', '1', NULL, NULL),
('gm_configuration/GM_PRICE_OFFER_VVCODE', 'true', 'true', 'switcher', NULL),
('gm_configuration/GM_QUICK_SEARCH', 'true', 'true', NULL, NULL),
('gm_configuration/GM_RECAPTCHA_PRIVATE_KEY', '', '', NULL, NULL),
('gm_configuration/GM_RECAPTCHA_PUBLIC_KEY', '', '', NULL, NULL),
('gm_configuration/GM_REVIEWS_VVCODE', 'true', 'true', 'switcher', NULL),
('gm_configuration/GM_SEARCH_TIMELINE', '20', '20', 'number', NULL),
('gm_configuration/GM_SEARCH_TIMEOUT', '20', '20', 'number', NULL),
('gm_configuration/GM_SEARCH_TRYOUT', '2', '2', 'number', NULL),
('gm_configuration/GM_SEO_BOOST_CATEGORIES', 'false', 'false', 'switcher', NULL),
('gm_configuration/GM_SEO_BOOST_CONTENT', 'false', 'false', 'switcher', NULL),
('gm_configuration/GM_SEO_BOOST_PRODUCTS', 'false', 'false', 'switcher', NULL),
('gm_configuration/GM_SEO_BOOST_SHORT_URLS', 'false', 'false', 'switcher', NULL),
('gm_configuration/GM_SET_OUT_OF_STOCK_PRODUCTS_INACTIVE', '0', '0', NULL, NULL),
('gm_configuration/GM_SHOP_OFFLINE', '', '', NULL, NULL),
('gm_configuration/GM_SHOP_OFFLINE_MSG',
 '<p><font face=\"Arial\" size=\"2\">Unser Shop ist aufgrund von Wartungsarbeiten im Moment nicht erreichbar.<br />\r\n</font><font face=\"Arial\" size=\"2\">Bitte besuchen Sie uns zu einem späteren Zeitpunkt noch einmal.</font><br />\r\n<br />\r\n<br />\r\n<br />\r\n<br />\r\n<br />\r\n<br />\r\n<br />\r\n<br />\r\n<a href=\"login_admin.php\"><font color=\"#808080\">Login</font></a></p>',
 '<p><font face=\"Arial\" size=\"2\">Unser Shop ist aufgrund von Wartungsarbeiten im Moment nicht erreichbar.<br />\r\n</font><font face=\"Arial\" size=\"2\">Bitte besuchen Sie uns zu einem späteren Zeitpunkt noch einmal.</font><br />\r\n<br />\r\n<br />\r\n<br />\r\n<br />\r\n<br />\r\n<br />\r\n<br />\r\n<br />\r\n<a href=\"login_admin.php\"><font color=\"#808080\">Login</font></a></p>',
 NULL, NULL),
('gm_configuration/GM_SHOW_ATTRIBUTES_STOCK', '0', '0', NULL, NULL),
('gm_configuration/GM_SHOW_CONDITIONS', '1', '1', '1-0-switcher', NULL),
('gm_configuration/GM_SHOW_CONDITIONS_CONFIRMATION', '1', '1', '1-0-switcher', NULL),
('gm_configuration/GM_SHOW_FLYOVER', '1', '1', NULL, NULL),
	('gm_configuration/GM_SHOW_IP', '0', '0', NULL, NULL),
('gm_configuration/GM_SHOW_PRIVACY_CONFIRMATION', '1', '1', '1-0-switcher', NULL),
('gm_configuration/GM_SHOW_PRIVACY_ORDER', '0', '0', NULL, NULL),
('gm_configuration/GM_SHOW_PRIVACY_REGISTRATION', '1', '1', '1-0-switcher', NULL),
('gm_configuration/GM_SHOW_PRIVACY_WITHDRAWAL_WEB_FORM', '1', '1', '1-0-switcher', NULL),
('gm_configuration/GM_SHOW_PRIVACY_GV_SEND', '1', '1', '1-0-switcher', NULL),
('gm_configuration/GM_SHOW_WISHLIST', 'true', 'true', 'switcher', NULL),
('gm_configuration/GM_SHOW_WITHDRAWAL', '1', '1', '1-0-switcher', NULL),
('gm_configuration/GM_SHOW_WITHDRAWAL_CONFIRMATION', '1', '1', '1-0-switcher', NULL),
('gm_configuration/GM_SITEMAP_GOOGLE_CHANGEFREQ', 'weekly', 'weekly', NULL, NULL),
('gm_configuration/GM_SITEMAP_GOOGLE_PRIORITY', '0.5', '0.5', NULL, NULL),
('gm_configuration/GM_SPECIALS_STARTPAGE', '6', '6', 'number', NULL),
('gm_configuration/GM_STARTPAGE_HOVER', '#b3ccdd', '#b3ccdd', NULL, NULL),
('gm_configuration/GM_STAT_PLOT_HEIGHT', '480', '480', NULL, NULL),
('gm_configuration/GM_STAT_PLOT_WIDTH', '640', '640', NULL, NULL),
('gm_configuration/GM_TELL_A_FRIEND', 'false', 'false', 'switcher', NULL),
('gm_configuration/GM_TELL_A_FRIEND_USE_CUSTOMER_EMAIL', 'true', 'true', NULL, NULL),
('gm_configuration/GM_TELL_A_FRIEND_VVCODE', 'true', 'true', 'switcher', NULL),
('gm_configuration/GM_TEMPLATE_NAME', 'xtc4', 'xtc4', NULL, NULL),
('gm_configuration/GM_TITLE_SHOW_STANDARD_META_TITLE', 'before', 'before', NULL, NULL),
('gm_configuration/GM_TITLE_USE_STANDARD_META_TITLE', '1', '1', '1-0-switcher', NULL),
('gm_configuration/GM_TITLE_CHANGE_CATEGORY_META_INDEX', '1', '1', '1-0-switcher', NULL),
('gm_configuration/GM_TOPMENU_MODE', 'mode1', 'mode1', NULL, NULL),
('gm_configuration/GM_UNDERLINE_LINKS', 'true', 'true', NULL, NULL),
('gm_configuration/GM_WITHDRAWAL_CONTENT_ID', '3889895', '3889895', NULL, NULL),
('gm_configuration/GM_WITHDRAWAL_CONTENT_ID_BACKUP', '9', '9', NULL, NULL),
('gm_configuration/GOOGLE_TAXONOMY_FILE_PATH',
 'http://www.google.com/basepages/producttype/taxonomy.de-DE.txt',
 'http://www.google.com/basepages/producttype/taxonomy.de-DE.txt', NULL, NULL),
('gm_configuration/LANGUAGE_PHRASE_CACHE_PRIORITIES',
 'original_sections,theme_sections,module_sections,user_sections,language_phrases_edited',
 'original_sections,theme_sections,module_sections,user_sections,language_phrases_edited', NULL, NULL),
('gm_configuration/MAIL_TEMPLATES_CACHE_PRIORITIES',
 'original_mail_templates,user_mail_templates,email_templates_edited',
 'original_mail_templates,user_mail_templates,email_templates_edited', NULL, NULL),
('gm_configuration/MAIN_SHOW_ATTRIBUTES', 'false', 'false', 'switcher', NULL),
('gm_configuration/MAIN_SHOW_GRADUATED_PRICES', 'false', 'false', 'switcher', NULL),
('gm_configuration/MAIN_SHOW_QTY', 'true', 'true', 'switcher', NULL),
('gm_configuration/MAIN_SHOW_QTY_INFO', 'false', 'false', 'switcher', NULL),
('gm_configuration/MAIN_VIEW_MODE_TILED', 'false', 'false', 'switcher', NULL),
('gm_configuration/NUMBER_OF_CUSTOMERS_PER_PAGE', '20', '20', NULL, NULL),
('gm_configuration/NUMBER_OF_ORDERS_PER_PAGE', '20', '20', NULL, NULL),
('gm_configuration/NUMBER_OF_PRODUCTS_PER_PAGE', '20', '20', NULL, NULL),
('gm_configuration/PERSISTENT_GLOBAL_FILTER', '0', '0', NULL, NULL),
('gm_configuration/POPUP_NOTIFICATION_STATUS', '0', '0', NULL, NULL),
('gm_configuration/PRICE_FILTER_FROM_ACTIVE', 'true', 'true', NULL, NULL),
('gm_configuration/PRICE_FILTER_TO_ACTIVE', 'true', 'true', NULL, NULL),
('gm_configuration/SECURE_TOKEN', '917f76ab5c3435026e8f6a7aca75458f', '917f76ab5c3435026e8f6a7aca75458f',
 NULL, NULL),
('gm_configuration/SHIPPING_INFOS_BACKUP', '1', '1', NULL, NULL),
('gm_configuration/SHOW_ACCOUNT_WITHDRAWAL_LINK', '0', '0', '1-0-switcher', NULL),
('gm_configuration/SHOW_ADDITIONAL_FIELDS_PRODUCT_DETAILS', 'true', 'true', 'switcher', NULL),
('gm_configuration/SHOW_FACEBOOK', 'false', 'false', 'switcher', NULL),
('gm_configuration/SHOW_WHATSAPP', 'false', 'false', 'switcher', NULL),
('gm_configuration/SHOW_FOOTER', 'false', 'false', NULL, NULL),
('gm_configuration/SHOW_GALLERY', 'true', 'true', NULL, NULL),
('gm_configuration/SHOW_MANUFACTURER_IMAGE_LISTING', 'true', 'true', 'switcher', NULL),
('gm_configuration/SHOW_MANUFACTURER_IMAGE_PRODUCT_DETAILS', 'true', 'true', 'switcher', NULL),
('gm_configuration/SHOW_OLD_DISCOUNT_PRICE', '1', '1', '1-0-switcher', NULL),
('gm_configuration/SHOW_OLD_GROUP_PRICE', '0', '0', '1-0-switcher', NULL),
('gm_configuration/SHOW_OLD_SPECIAL_PRICE', '0', '0', '1-0-switcher', NULL),
('gm_configuration/SHOW_NORMAL_PRICE_ONLY_FOR_NATIONAL_SHIPPING', 'false', 'false', 'switcher', NULL),
('gm_configuration/SHOW_PINTEREST', 'false', 'false', 'switcher', NULL),
('gm_configuration/SHOW_PRODUCTS_COUNT', 'false', 'false', 'switcher', NULL),
('gm_configuration/SHOW_PRODUCT_RIBBONS', 'true', 'true', 'switcher', NULL),
('gm_configuration/SHOW_RATING_IN_GRID_AND_LISTING', 'true', 'true', 'switcher', NULL),
('gm_configuration/SHOW_SUBCATEGORIES', 'true', 'true', 'switcher', NULL),
('gm_configuration/SHOW_SUBCATEGORIES_PARENT',  'false', 'false', 'switcher', NULL),
('gm_configuration/SHOW_TOP_COUNTRY_SELECTION', 'true', 'true', 'switcher', NULL),
('gm_configuration/SHOW_TOP_CURRENCY_SELECTION', 'false', 'false', 'switcher', NULL),
('gm_configuration/SHOW_TWITTER', 'false', 'false', 'switcher', NULL),
('gm_configuration/SHOW_ZOOM', 'true', 'true', 'switcher', NULL),
('gm_configuration/STARTPAGE_FILTER_ACTIVE', '0', '0', NULL, NULL),
('gm_configuration/SUPPRESS_INDEX_IN_URL', 'true', 'true', 'switcher', NULL),
('gm_configuration/TAX_INFO_TAX_FREE', 'false', 'false', NULL, NULL),
('gm_configuration/DEFAULT_TAX_CLASS_ID', '1', '1', 'tax-class', NULL),
('gm_configuration/TOPBAR_NOTIFICATION_COLOR', '#ffffff', '#ffffff', NULL, NULL),
('gm_configuration/TOPBAR_NOTIFICATION_MODE', 'hideable', 'hideable', NULL, NULL),
('gm_configuration/TOPBAR_NOTIFICATION_STATUS', '0', '0', NULL, NULL),
('gm_configuration/TRUNCATE_FLYOVER', '35', '35', NULL, NULL),
('gm_configuration/TRUNCATE_FLYOVER_TEXT', '150', '150', NULL, NULL),
('gm_configuration/TRUNCATE_PRODUCTS_HISTORY', '16', '16', 'number', NULL),
('gm_configuration/TRUNCATE_PRODUCTS_NAME', '40', '40', 'number', NULL),
('gm_configuration/TRUSTED_SHOP_ID', '', '', NULL, NULL),
('gm_configuration/UPLOAD_CONTENT_EXTENSIONS', 'html,htm,xhtml,xml,txt,js,pdf',
 'html,htm,xhtml,xml,txt,js,pdf', NULL, NULL),
('gm_configuration/USE_SEO_BOOST_LANGUAGE_CODE', 'false', 'false', 'switcher', NULL),
('gm_configuration/WITHDRAWAL_PDF_ACTIVE', '1', '1', '1-0-switcher', NULL),
('gm_configuration/WITHDRAWAL_WEBFORM_ACTIVE', '0', '0', '1-0-switcher', NULL),
('gm_configuration/ALWAYS_SHOW_CONTINUE_SHOPPING_BUTTON', '0', '0', '1-0-switcher', NULL),
('gm_configuration/USE_UPCOMING_PRODUCT_SWIPER_ON_INDEX', 'true', 'true', 'switcher', NULL),
('gm_configuration/USE_TOP_PRODUCT_SWIPER_ON_INDEX', 'true', 'true', 'switcher', NULL),
('gm_configuration/USE_SPECIAL_PRODUCT_SWIPER_ON_INDEX', 'false', 'false', 'switcher', NULL),
('gm_configuration/USE_NEW_PRODUCT_SWIPER_ON_INDEX', 'true', 'true', 'switcher', NULL),
('gm_configuration/PRIVACY_CHECKBOX_REGISTRATION', '0', '0', '1-0-switcher', NULL),
('gm_configuration/PRIVACY_CHECKBOX_CALLBACK', '0', '0', '1-0-switcher', NULL),
('gm_configuration/PRIVACY_CHECKBOX_CONTACT', '0', '0', '1-0-switcher', NULL),
('gm_configuration/PRIVACY_CHECKBOX_ASK_PRODUCT_QUESTION', '0', '0', '1-0-switcher', NULL),
('gm_configuration/PRIVACY_CHECKBOX_FOUND_CHEAPER', '0', '0', '1-0-switcher', NULL),
('gm_configuration/PRIVACY_CHECKBOX_REVIEWS', '0', '0', '1-0-switcher', NULL),
('gm_configuration/PRIVACY_CHECKBOX_ACCOUNT_EDIT', '0', '0', '1-0-switcher', NULL),
('gm_configuration/PRIVACY_CHECKBOX_ADDRESS_BOOK', '0', '0', '1-0-switcher', NULL),
('gm_configuration/PRIVACY_CHECKBOX_NEWSLETTER', '0', '0', '1-0-switcher', NULL),
('gm_configuration/PRIVACY_CHECKBOX_CHECKOUT_SHIPPING', '0', '0', '1-0-switcher', NULL),
('gm_configuration/PRIVACY_CHECKBOX_CHECKOUT_PAYMENT', '0', '0', '1-0-switcher', NULL),
('gm_configuration/PRIVACY_CHECKBOX_WITHDRAWAL_WEB_FORM', '0', '0', '1-0-switcher', NULL),
('gm_configuration/PRIVACY_CHECKBOX_GV_SEND', '0', '0', '1-0-switcher', NULL),
('gm_configuration/DATA_TRANSFER_TO_TRANSPORT_COMPANIES_STATUS', '0', '0', '1-0-switcher', NULL),
('gm_configuration/DATA_TRANSFER_TO_TRANSPORT_COMPANIES_REQUIRED', '0', '0', '1-0-switcher', NULL),
('gm_configuration/DATA_TRANSFER_TO_TRANSPORT_COMPANIES_SETTINGS', '', '', NULL, NULL),
('gm_configuration/USE_SMALLER_IMAGES_FOR_PRODUCTS', 'false', 'false', 'switcher', NULL),
('gm_configuration/GRADUATED_ASSIGN', '1', '1', '1-0-switcher', NULL),
('gm_configuration/LAST_NEW_SHOP_URL_NOTIFY', '0', '0', NULL, NULL),
('gm_configuration/GM_RECOMMENDED_PRODUCTS_STARTPAGE', '10', '10', 'number', NULL),
('gm_configuration/MODULE_CENTER_RESPONSIVEFILEMANAGER_INSTALLED', '1', '1', NULL, NULL),
('gm_configuration/SHOW_ABANDONMENT_OF_WITHDRAWL_DOWNLOAD', '1', '1', '1-0-switcher', NULL),
('gm_configuration/SHOW_ABANDONMENT_OF_WITHDRAWL_SERVICE', '1', '1', '1-0-switcher', NULL),
('gm_configuration/CHECK_ABANDONMENT_OF_WITHDRAWL_DOWNLOAD', '0', '0', '1-0-switcher', NULL),
('gm_configuration/CHECK_ABANDONMENT_OF_WITHDRAWL_SERVICE', '0', '0', '1-0-switcher', NULL),
('gm_configuration/GM_CREATE_ACCOUNT_VVCODE', 'false', 'false', 'switcher', NULL),
('gm_configuration/PRODUCT_REVIEW_NAME', 'short_nothing', 'short_nothing', 'product-review-mode', NULL),
('gm_configuration/LOG_IP_CALLBACK', '0', '0', '1-0-switcher', NULL),
('gm_configuration/LOG_IP_CONTACT', '0', '0', '1-0-switcher', NULL),
('gm_configuration/LOG_IP_TELL_A_FRIEND', '0', '0', '1-0-switcher', NULL),
('gm_configuration/LOG_IP_FOUND_CHEAPER', '0', '0', '1-0-switcher', NULL),
('gm_configuration/LOG_IP_REVIEWS', '0', '0', '1-0-switcher', NULL),
('gm_configuration/LOG_IP_ACCOUNT_CONTACT', '0', '0', '1-0-switcher', NULL),
('gm_configuration/LOG_IP_ACCOUNT_ADDRESS_BOOK', '0', '0', '1-0-switcher', NULL),
('gm_configuration/LOG_IP_ACCOUNT_NEWSLETTER', '0', '0', '1-0-switcher', NULL),
('gm_configuration/LOG_IP_WITHDRAWAL_WEB_FORM', '0', '0', '1-0-switcher', NULL),
('gm_configuration/LOG_IP_GV_SEND', '0', '0', '1-0-switcher', NULL),
('gm_configuration/LOG_IP_SHIPPING', '0', '0', '1-0-switcher', NULL),
('gm_configuration/LOG_IP_ORDER_SHIPPING_ADDRESS', '0', '0', '1-0-switcher', NULL),
('gm_configuration/LOG_IP_ORDER_PAYMENT_ADDRESS', '0', '0', '1-0-switcher', NULL),
('gm_configuration/SHOW_PRODUCTS_MODEL_IN_SHOPPING_CART_AND_WISHLIST', 'false', 'false', 'switcher', NULL),
('gm_configuration/SHOW_PRODUCTS_MODEL_IN_PRODUCT_DETAILS', 'true', 'true', 'switcher', NULL),
('gm_configuration/SHOW_PRODUCTS_MODEL_IN_PRODUCT_LISTS', 'false', 'false', 'switcher', NULL),
('gm_configuration/SHOW_RATING_AS_TAB', 'false', 'false', 'switcher', NULL),
('gm_configuration/CATEGORY_UNFOLD_DEFAULT_LEVEL', '10', '10', 'number', NULL),
('gm_configuration/MODULE_CENTER_GAMBIODIRECTHELP_INSTALLED', '1', '1', NULL, NULL),
('gm_configuration/GALLERY_LIGHTBOX', 'false', 'false', 'switcher', NULL),
('gm_configuration/ENABLE_JS_HYPHENATION', 'false', 'false', 'switcher', NULL),
('gm_configuration/ENABLE_LIVE_SEARCH', 'true', 'true', 'switcher', NULL),
('gm_configuration/DISPLAY_OF_PROPERTY_COMBINATION_SELECTION', 'DISPLAY_ONLY_PROPERTY_IMAGES', 'DISPLAY_ONLY_PROPERTY_IMAGES', NULL, NULL),
('gm_configuration/PDF_FOOTER_REPLACE_COLUMN', 'null', 'null', NULL, NULL),
('gm_configuration/AUTO_UPDATER_UPDATES_URL', 'https://updates.gambio-support.de/v2/check.php',
 'https://updates.gambio-support.de/v2/check.php', NULL, NULL),
('gm_configuration/AUTO_UPDATER_FEEDBACK_URL', 'https://updates.gambio-support.de/v2/callingHome.php',
 'https://updates.gambio-support.de/v2/callingHome.php', NULL, NULL),
('gm_configuration/AUTO_UPDATER_ACCEPT_DATA_PROCESSING', 'false', 'false', NULL, NULL),
('gm_configuration/GAMBIO_STORE_URL', 'https://store.gambio.com/a', 'https://store.gambio.com/a', NULL, NULL),
('gm_configuration/GAMBIO_STORE_IS_REGISTERED', 'false', 'false', NULL, NULL),
('gm_configuration/GAMBIO_STORE_TOKEN', '', '', NULL, NULL),
('gm_configuration/ADMIN_FEED_ACCEPTED_SHOP_INFORMATION_DATA_PROCESSING', 'false', 'false', 'switcher', NULL),
('gm_configuration/DISPLAY_0_PROCENT_TAX', '0', '0', '1-0-switcher', NULL),
('gm_configuration/MANUAL_ORDER_PAYMENT', '', '', 'default-payment-method', NULL),
('gm_configuration/GM_LOG_IP_LOGIN', '0', '0', '1-0-switcher', NULL),
('gm_configuration/GOOGLE_API_KEY', '', '', NULL, NULL),
('gm_configuration/SHOW_SHIPPING_WEIGHT_CHECKOUT', 'true', 'true', 'switcher', NULL),
('gm_configuration/SHOW_FULL_SHIPPING_COUNTRY_NAME', 'false', 'false', 'switcher', NULL);

INSERT INTO `gx_configurations` (`key`, `value`, `default`, `type`, `sort_order`)
VALUES ('gm_configuration/SEND_X_FRAME_OPTIONS_SAMEORIGIN_HEADER', 'true', 'true', 'switcher', NULL),
('error_pages/customPageNotFound', 'true', 'true', NULL, NULL),
('error_pages/errorHtml',
 '{\r\n	  \"DE\": \"<center><b>Leider ist ein unerwarteter Fehler aufgetreten.</b></center>\",\r\n	  \"EN\": \"<center><b>Unfortunately an unexpected error occurred.</b></center>\"\r\n  }',
 '{\r\n	  \"DE\": \"<center><b>Leider ist ein unerwarteter Fehler aufgetreten.</b></center>\",\r\n	  \"EN\": \"<center><b>Unfortunately an unexpected error occurred.</b></center>\"\r\n  }',
 NULL, NULL),
('error_pages/notFoundHtml',
 '{\r\n	  \"DE\": \"<center><b>Die aufgerufene Seite konnte nicht gefunden werden.</b></center>\",\r\n	  \"EN\": \"<center><b>The requested page could not be found.</center>\"\r\n  }',
 '{\r\n	  \"DE\": \"<center><b>Die aufgerufene Seite konnte nicht gefunden werden.</b></center>\",\r\n	  \"EN\": \"<center><b>The requested page could not be found.</center>\"\r\n  }',
 NULL, NULL),
('error_pages/userFriendlyErrorHandling', 'true', 'true', NULL, NULL),
('modules/admin/responsivefilemanager/use_in_attribute_pages', '1', '1', NULL, NULL),
('modules/admin/responsivefilemanager/use_in_banner_manager_pages', '1', '1', NULL, NULL),
('modules/admin/responsivefilemanager/use_in_ckeditor', '1', '1', NULL, NULL),
('modules/admin/responsivefilemanager/use_in_content_manager_pages', '1', '1', NULL, NULL),
('modules/admin/responsivefilemanager/use_in_email_pages', '1', '1', NULL, NULL),
('modules/admin/responsivefilemanager/use_in_manufacturer_pages', '1', '1', NULL, NULL),
('modules/admin/responsivefilemanager/use_in_product_and_category_pages', '1', '1', NULL, NULL),
('modules/admin/responsivefilemanager/use_in_shipping_status_pages', '1', '1', NULL, NULL),
('modules/GambioDirectHelp/active', '1', '1', NULL, NULL),
('extensions/giftsystem/releaseOrderStatuses', '', '', NULL, NULL),
('extensions/giftsystem/securityCodeLength', '10', '10', NULL, NULL),
('extensions/giftsystem/newSignupGiftVoucherAmount', '0', '0', NULL, NULL),
('extensions/giftsystem/newSignupDiscountCoupon', '', '', NULL, NULL),
('gambio_updater/v4.5.1.0/variant_migration', '1', '1', NULL, NULL),
('gm_configuration/APILAYER_API_KEY', '', '', NULL, 0),
('gm_configuration/SERVICE_WITHOUT_SHIPPING', 'false', 'false', 'switcher', NULL),
('gm_configuration/CHECK_FOR_GAMBIO_STORE_UPDATES', '1', NULL, NULL, NULL);

INSERT INTO `gx_configurations` (`key`, `value`, `default`, `type`, `sort_order`)
VALUES
    ('cronjobs/DeleteLogs/active', 'true', 'true', null, null),
    ('cronjobs/DeleteLogs/olderThan', '2', '2', null, null);
